import socket
import unittest

import coverage

from jafar.tests.integration import *
from jafar.tests.unittests.arranger import *
from jafar.tests.unittests.estimators import *
from jafar.tests.unittests.feed.recommenders import *
from jafar.tests.unittests.feed.strategy import *
from jafar.tests.unittests.scoring import *
from jafar.tests.unittests.storages import *
from jafar.tests.unittests.pipelines.blocks.blend import *
from jafar.tests.unittests.pipelines.blocks.data import *
from jafar.tests.unittests.pipelines.blocks.classifier import *
from jafar.tests.unittests.pipelines.blocks.estimator import *
from jafar.tests.unittests.pipelines.blocks.features import *
from jafar.tests.unittests.pipelines.blocks.google_play import *
from jafar.tests.unittests.pipelines.blocks.mapping import *
from jafar.tests.unittests.pipelines.blocks.merge import *
from jafar.tests.unittests.pipelines.blocks.selection import *
from jafar.tests.unittests.pipelines.blocks.target import *
from jafar.tests.unittests.pipelines.blocks.transformer import *
from jafar.tests.unittests.pipelines.blocks.permutation import *
from jafar.tests.unittests.pipelines.predefined import *
from jafar.tests.unittests.static_dict import *
from jafar.tests.unittests.image_composer import *


def make_test_lock_name(name):
    return "{name}_tests_on_{host}".format(name=name, host=socket.gethostname())


class CoverageTestRunner(unittest.TextTestRunner):
    def run(self, test):
        cov = coverage.Coverage(include=["jafar/*"])
        cov.start()
        result = unittest.TextTestRunner.run(self, test)
        cov.stop()
        cov.html_report(directory="html_coverage_report")
        return result


if __name__ == '__main__':
    unittest.main(verbosity=2)
