import numpy as np
from Cython.Distutils import build_ext
from setuptools import find_packages, setup
from setuptools.extension import Extension

from version import VERSION

extensions = [
    Extension(
        "jafar.utils.fast",
        ["jafar/utils/fast.pyx"],
        extra_compile_args=['-fopenmp'],
        extra_link_args=['-fopenmp'],
    ),
    Extension(
        "jafar.utils.cmph_wrapper",
        ["jafar/utils/cmph_wrapper.pyx"],
        include_dirs=[np.get_include()],
        libraries=["cmph"]
    ),
]

setup(
    name='jafar',
    version=VERSION,
    author='Artem Khurshudov',
    author_email='anglerfish@yandex-team.ru',
    packages=find_packages(),
    long_description=open('README.md').read(),
    package_data={
        'jafar': [
            'templates/*.html',
            'templates/stand/*.html',
            'templates/evaluation/*.html',
            'static/stand/svg/ajax_loader.svg',
        ],
        'jafar_yt': [
            'nile_wheels/*.whl'
        ]
    },
    cmdclass={'build_ext': build_ext},
    ext_modules=extensions,
    test_suite='run_tests',
    test_runner='run_tests:CoverageTestRunner'
)
