# -*- coding: utf-8 -*-

import requests
from fabric.api import *

CONDUCTOR_API_TEMPLATE = 'https://c.yandex-team.ru/api-cached/groups2hosts/{group}'

role_group_names = {
    'testing': ['mobile_test_backoffice_front'],
    'stable': ['mobile_backoffice_front']
}

env.roledefs = {}


def get_hosts_from_conductor(group_name):
    response = requests.get(CONDUCTOR_API_TEMPLATE.format(group=group_name))
    return response.content.split()


for role, group_names in role_group_names.iteritems():
    env.roledefs[role] = []
    for group_name in group_names:
        env.roledefs[role].extend(get_hosts_from_conductor(group_name))

env.roles = env.roles or ['testing']


@task
@parallel
def changes(s):
    run('grep "%s" /var/log/yandex/localization_admin/changes.log || true' % s)


@task
@parallel
def deltas(s):
    run('grep "%s" /var/log/yandex/localization_admin/deltas.log || true' % s)
