from bson.objectid import ObjectId
from flask import request
import pymongo
import shutil
from tempfile import mkdtemp
import time
import types


def autoreconnect(f):
    """Decorator for automatic retry in case of pymongo AutoReconnect error"""
    def wrap(*args, **kwargs):
        timeouts = [0.5, 1, 2]
        while True:
            try:
                result = f(*args, **kwargs)
                return result
            except pymongo.errors.AutoReconnect:
                if timeouts:
                    time.sleep(timeouts.pop(0))
                    continue
                raise

    return wrap


class BaseDecoratorMeta(type):
    @staticmethod
    def decorate(f):
        raise NotImplementedError

    def __init__(self, name, bases, attrs):
        for attr_name in dir(self):
            if isinstance(getattr(self, attr_name), types.UnboundMethodType):
                setattr(self, attr_name, self.decorate(getattr(self, attr_name)))

        super(BaseDecoratorMeta, self).__init__(name, bases, attrs)

def generate_id(condition, string=True):
    if getattr(request, '_id', None) is None:
        _id = ObjectId()
        if string:
            _id = str(_id)
        while not condition(_id):
            _id = ObjectId()
            if string:
                _id = str(_id)
        request._id = _id
    else:
        if not condition(request._id):
            raise AssertionError("Generated id does not satisfy all conditions")
    return request._id
