import os
import logging

from ylog.format import QloudJsonFormatter


# Custom classes to enable new style formatting
class LogRecord(logging.LogRecord):
    def getMessage(self):
        msg = self.msg
        if self.args:
            if isinstance(self.args, dict):
                msg = msg.format(**self.args)
            else:
                try:
                    msg = msg % self.args
                except TypeError:
                    msg = msg.format(*self.args)
        return msg


class Logger(logging.Logger):
    def makeRecord(self, name, level, fn, lno, msg, args, exc_info, func=None, extra=None):
        rv = LogRecord(name, level, fn, lno, msg, args, exc_info, func)
        if extra is not None:
            for key in extra:
                rv.__dict__[key] = extra[key]
        return rv


logging.setLoggerClass(Logger)


def getLogger(name):
    return logging.getLogger(name)


def log(level, msg, *args, **kwargs):
    return logging.log(level, msg, *args, **kwargs)


def debug(msg, *args, **kwargs):
    return logging.debug(msg, *args, **kwargs)


def info(msg, *args, **kwargs):
    return logging.info(msg, *args, **kwargs)


def warning(msg, *args, **kwargs):
    return logging.warning(msg, *args, **kwargs)


def error(msg, *args, **kwargs):
    return logging.error(msg, *args, **kwargs)


logger = logging.root
logger.setLevel(logging.INFO)
logger.propagate = 0
handler = logging.StreamHandler()
handler.setLevel(logging.INFO)
if 'QLOUD_ENVIRONMENT' in os.environ:
    formatter = QloudJsonFormatter()
else:
    formatter = logging.Formatter('[%(asctime)s] [%(process)d] [%(levelname)s] [%(name)s] %(message)s',
                                  '%Y-%m-%d %H:%M:%S')
handler.setFormatter(formatter)
logger.addHandler(handler)
