# coding: utf-8
from localization_admin.db import db
from localization_admin.models.fields import SerializedListField

HOST_REGEX = r'^((([a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9\-]*[a-zA-Z0-9])\.)*([A-Za-z0-9]|[A-Za-z0-9][A-Za-z0-9\-]*[A-Za-z0-9]))|((([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5]))$'


class ExtendedParams(db.DynamicEmbeddedDocument):
    crypta_loyalty = db.StringField(help_text='Loyalty level towards Yandex: user`s loyalty > value [0.0, 1.0]')
    placement_id = db.StringField(help_text='Placement id == value')
    user_creation_date = db.TimestampDateTimeField(help_text='user`s creation time > value', verbose_name="User Creation Time From")
    user_creation_date_to = db.TimestampDateTimeField(help_text='user`s creation time < value', verbose_name="User Creation Time To")
    countryCode = db.StringField(help_text='Country of mobile operator (from SIM)')
    #host = db.StringField(regex=HOST_REGEX, help_text='Hostname without http:// and trailing slash')
    clid = db.StringField(help_text="Client's ID passed through 'clid' request parameter")
    #countryInit = db.StringField(regex='^[a-zA-Z]{2}',
    #                             help_text="""Country, where the application
    #                                was first installed (Two uppercase letters)""")
    installReferrer = db.StringField(help_text="String, passed to application by Google Play")
    referrerPattern = db.StringField(help_text="String that must be found as substring "
                                               "inside string passed to app by GooglePlay")
    #clidsSet = db.MongoClidsSetField(help_text="Clids passed through 'clids_set' request parameter")
    #brandId = db.StringField(help_text="Brand identifier, passed through 'brand_id' request parameter")
    #activeWifiSsid = db.StringField(help_text="Name of the wifi hotspot used to connect to internet")
    os_name = db.StringField(help_text="Client's operating system name", verbose_name="OS Name")
    serial_number = SerializedListField(db.StringField(), help_text="Client's serial number", verbose_name="Serial Number")
    yphone_id = SerializedListField(db.StringField(), help_text="Yandex Phone ID", verbose_name="YPhone ID")
    yphone_batch = SerializedListField(db.StringField(), help_text="Yandex Phone Batch ID", verbose_name="YPhone Batch ID")
    mac_address_wifi = SerializedListField(db.StringField(), help_text="Client's MAC address wifi",
                                           verbose_name="MAC address wifi")
    mac_address_ethernet = SerializedListField(db.StringField(), help_text="Client's MAC address ethernet",
                                           verbose_name="MAC address ethernet")
