# encoding: utf-8
from localization_admin.db import db
from localization_admin.models.support_info import OperationSystem
from .version_range import VersionRange


family_choices = [('android', 'Android'), ('iphone', 'iOS'), ('wp', 'Windows Phone')]


class MobilePlatform(db.EmbeddedDocument):
    name = db.ReferenceField(OperationSystem, required=True)
    version = db.EmbeddedDocumentField(VersionRange)

    def __unicode__(self):
        return self.name


class MobilePlatformFamily(db.EmbeddedDocument):
    name = db.StringField(required=True, choices=family_choices)
    version = db.EmbeddedDocumentField(VersionRange)

    def __unicode__(self):
        return self.name
