# encoding: utf-8
from localization_admin.db import db
from mongoengine import ValidationError
from localization_admin.models.fields import SerializedListField


class OsVersion(db.EmbeddedDocument):
    min_os_version = db.StringField(help_text="Client's operating system minimal version: value >= min_os_version",
                                    verbose_name="Minimal OS version")
    max_os_version = db.StringField(help_text="Client's operating system maximal version: value <= max_os_version",
                                    verbose_name="Maximal OS version")
    min_build_version = db.StringField(help_text="Client's minimal build version: value >= min_build_version",
                                       verbose_name="Minimal build version for os_version")
    max_build_version = db.StringField(help_text="Client's maximal build version: value <= max_build_version",
                                       verbose_name="Maximal build version for os_version")
    build_version_list = SerializedListField(db.StringField(), help_text="Build versions", verbose_name="Build version")

    def validate(self, clean=True):
        no_os_version = not self.min_os_version and not self.max_os_version
        build_version = self.min_build_version or self.max_build_version or self.build_version_list
        if no_os_version and build_version:
            raise ValidationError('set os_version for build_version')
        return True
