from localization_admin.db import db
from .version_range import VersionRange
from localization_admin.models.support_info import YandexApp


class VersionRangeApplication(db.EmbeddedDocument):
    name = db.ReferenceField(YandexApp, required=True)
    version = db.EmbeddedDocumentField(VersionRange)

    def __unicode__(self):
        return self.name


class VersionRangeAndroidApplication(db.EmbeddedDocument):
    name = db.PropertyReferenceField(YandexApp, 'android_package_name', required=True)
    version = db.EmbeddedDocumentField(VersionRange)

    def __unicode__(self):
        return self.name
