from datetime import datetime

from mongoengine.fields import DateTimeField

from localization_admin.db import db
from localization_admin.models.details import ValueBlock
from localization_admin.models.helpers import default_id


class LocalizationOptions(db.EmbeddedDocument):
    audience_salt = db.StringField(default=default_id)


class LocalizationData(db.Document):
    id = db.StringField(primary_key=True)
    options = db.EmbeddedDocumentField(LocalizationOptions)
    values = db.SortableListField(db.EmbeddedDocumentField(ValueBlock), required=True)
    updated_at = DateTimeField()

    meta = {'db_alias': 'localizations', 'strict': False}

    def validate(self, clean=True):
        self.updated_at = datetime.utcnow()
        return super(LocalizationData, self).validate(clean=clean)
