# coding: utf-8
from localization_admin.db import db
from mongoengine.errors import ValidationError


class LocaleModel(db.Document):
    language = db.StringField(required=False, regex='^[a-z]{2}$', help_text='Two lowercase letters: ru, en')
    language_title = db.StringField(required=False, min_length=1, max_length=50)
    country = db.StringField(required=False, regex='^[A-Z]{2}$', help_text='Two lowercase letters: RU, US')
    country_title = db.StringField(required=False, min_length=1, max_length=50)

    meta = {
        'db_alias': 'localizations',
        'collection': 'localization._locale',
    }

    def validate(self, clean=True):
        result = super(LocaleModel, self).validate(clean=clean)
        errors = {}
        if self.language and not self.language_title:
            errors['language_title'] = 'language name must be defined'

        if self.country and len(self.country_title) == 0:
            errors['country_title'] = 'country name must be defined'

        if errors:
            message = "ValidationError (%s:%s) " % (self._class_name, self.pk)
            raise ValidationError(message, errors=errors)

        return result

    def __unicode__(self):
        result = u''
        if self.language and self.country:
            result = u'%s_%s' % (self.language, self.country)
        elif self.language or self.country:
            result = unicode(self.language or self.country)
        return result
