# encoding: utf-8
from localization_admin.db import db
from localization_admin.models.details import IpRange


class MobileOperator(db.Document):
    """Model represents mobile operator from localization._Operators collection."""
    id = db.StringField(primary_key=True)
    operator_id = db.IntField(db_field='operatorId')
    countryCode = db.IntField()
    ip_ranges = db.ListField(db.EmbeddedDocumentField(IpRange), db_field='ipRanges', default=None)

    meta = {'db_alias': 'localizations',
            'collection': 'localization._Operators'}

    def __unicode__(self):
        return self.id
