# coding: utf-8
import re
from localization_admin.db import db


class StartrekInteraction(db.Document):
    id = db.StringField(primary_key=True)
    project = db.StringField(required=True)
    enabled = db.ListField(db.StringField(), verbose_name='enabled <id> regex', default=[])
    excluded = db.ListField(db.StringField(), verbose_name='excluded <id> regex', default=[])

    meta = {
        'db_alias': 'localizations',
        'collection': 'localization._Startrek_interaction',
        'strict': False
    }

    def __unicode__(self):
        return u'project: %s, enabled: %s, excluded: %s' % (self.project, self.enabled, self.excluded)

    @staticmethod
    def is_applicable(project, key_name):
        for config in StartrekInteraction.objects:
            re_project = re.compile(config.project)
            if not re_project.match(project):
                continue
            for enabled_pattern in config.enabled:
                match_enabled = re.match(enabled_pattern, key_name, re.UNICODE)
                if match_enabled:
                    # check if it in excluded list
                    for excluded_pattern in config.excluded:
                        match_excluded = re.match(excluded_pattern, key_name, re.UNICODE)
                        if match_excluded:
                            break
                    else:
                        return True  # not in excluded list
        return False
