// Flashing
function FlashMessage(message, type) {
    type = typeof type !== 'undefined' ? type : 'success';
    content =  '<div class="alert alert-' + type + '">';
    content += '<a class="close" data-dismiss="alert" href="javascript:void(0)">x</a>';
    content += message;
    content += '</div>';
    $('.flashed_messages').append(content);
};

// Admin mode
function setMode(el) {
    xmlhttp = GetXMLHttp();
    xmlhttp.open('POST', '/settings/mode/', true);
    params = "adminMode=" + ($(el).is(':checked') ? 1 : 0);
    xmlhttp.send(params);
    return true;
};

// Field visability
function FillField(el) {
    $(el).siblings().removeClass("hide");
    $(el).addClass("hide");
    $(el).parent().next().children().first().removeClass('hide');
};

function EmptyField(el) {
    $(el).siblings().removeClass("hide");
    $(el).addClass("hide");
    $(el).parent().next().children().first().addClass('hide');;
};

// Submit helper
function SmartSubmit(form) {
    $(form).find('.hide.field_container').remove();
    $('.ignore-on-submit').remove();
    $('input:checkbox:checked').next().prop('disabled', true);  // for CustomCheckboxInput widget
    return true;
};

// Hash helper
function ChangeHashAndSubmit(clicked_input, new_hash){
    window.location.hash = new_hash;
    $(clicked_input).closest("form").submit();
};

function IterateAndReplace(parentEl, matcher, newText)
{
    var children = parentEl.children;
    for (var i = 0; i < children.length; i++) {
        var child = children[i];
        if (child.hasAttribute('id')) {
            child.id = child.id.replace(matcher, newText);
        }
        if (child.hasAttribute('name')) {
            child.setAttribute('name', child.getAttribute('name').replace(matcher, newText));
        }
        if (child.hasAttribute('for')) {
            child.setAttribute('for', child.getAttribute('for').replace(matcher, newText));
        }
        IterateAndReplace(child, matcher, newText);
    }
}

function swapNodes(a, b) {
    var aparent = a.parentNode;
    var asibling = a.nextSibling === b ? a : a.nextSibling;
    b.parentNode.insertBefore(a, b);
    aparent.insertBefore(b, asibling);
}

// SortableListField support
function MoveUp(el) {
    // Determine ids
    subfield_id = $(el).closest('.inline-field').attr('id');
    last_delimeter_index = subfield_id.lastIndexOf("-");
    subfield_template_id = subfield_id.slice(0, last_delimeter_index);
    subfield_num = parseInt(subfield_id.slice(last_delimeter_index + 1));
    prev_subfield_id = subfield_template_id + "-" + (subfield_num - 1).toString();
    // Get field containers
    source_field_container = $('#' + subfield_id).find('.inline-field-container').first().get(0);
    prev_subfield_container = $('#' + prev_subfield_id).find('.inline-field-container').first().get(0);
    // Swap them
    swapNodes(source_field_container, prev_subfield_container);
    // Replace controlling attributes
    prev_matcher = new RegExp(prev_subfield_id, 'g');
    source_matcher = new RegExp(subfield_id, 'g');
    IterateAndReplace(source_field_container, source_matcher, prev_subfield_id);
    IterateAndReplace(prev_subfield_container, prev_matcher, subfield_id);
};

function MoveDown(el) {
    // Determine ids
    subfield_id = $(el).closest('.inline-field').attr('id');
    last_delimeter_index = subfield_id.lastIndexOf("-");
    subfield_template_id = subfield_id.slice(0, last_delimeter_index);
    subfield_num = parseInt(subfield_id.slice(last_delimeter_index + 1));
    next_subfield_id = subfield_template_id + "-" + (subfield_num + 1).toString();
    // Get field containers
    source_field_container = $('#' + subfield_id).find('.inline-field-container').first().get(0);
    next_subfield_container = $('#' + next_subfield_id).find('.inline-field-container').first().get(0);
    // Swap them
    swapNodes(next_subfield_container, source_field_container);
    // Replace controlling attributes
    next_matcher = new RegExp(next_subfield_id, 'g');
    source_matcher = new RegExp(subfield_id, 'g');
    IterateAndReplace(source_field_container, source_matcher, next_subfield_id);
    IterateAndReplace(next_subfield_container, next_matcher, subfield_id);
};

// Ajax helper
function GetXMLHttp() {
    var xmlhttp;
    if (window.XMLHttpRequest) {
        xmlhttp = new XMLHttpRequest();
    }
    else {
        xmlhttp = new ActiveObject("Microsoft.XMLHTTP");
    }
    return xmlhttp;
};

// Spinner
function ShowSpinner() {
    $('#spinner').show();
}

function HideSpinner() {
    $('#spinner').hide();
}


if (typeof(String.prototype.strip_condition) === "undefined")
{
    String.prototype.strip_condition = function()
    {
        return String(this).replace(/^!*/g, '');
    };
};

function equal(a, b) {
    if (a === b) return true;
    if (a === undefined || b === undefined) return false;
    if (a === null || b === null) return false;
    // Check whether 'a' or 'b' is a string (primitive or object).
    // The concatenation of an empty string (+'') converts its argument to a string's primitive.
    if (a.constructor === String) return a+'' === b+''; // a+'' - in case 'a' is a String object
    if (b.constructor === String) return b+'' === a+''; // b+'' - in case 'b' is a String object
    return false;
};

function splitVal(string, separator) {
    var val, i, l;
    if (string === null || string.length < 1) return [];
    val = string.split(separator);
    for (i = 0, l = val.length; i < l; i = i + 1) val[i] = $.trim(val[i]);
    return val;
};

(function() {
    var AdminForm = function() {
      // Field converters
      var fieldConverters = [];


      /**
      * Process AJAX fk-widget
      */
      function processAjaxWidget($el, name) {
        var multiple = $el.attr('data-multiple') == '1';

        var opts = {
          width: 'resolve',
          minimumInputLength: 1,
          placeholder: 'data-placeholder',
          ajax: {
            url: $el.attr('data-url'),
            data: function(term, page) {
              return {
                query: term,
                offset: (page - 1) * 10,
                limit: 10
              };
            },
            results: function(data, page) {
              var results = [];

              for (var k in data) {
                var v = data[k];

                results.push({id: v[0], text: v[1]});
              }

              return {
                results: results,
                more: results.length == 10
              };
            }
          },
          initSelection: function(element, callback) {
            $el = $(element);
            var value = jQuery.parseJSON($el.attr('data-json'));
            var result = null;

            if (value) {
              if (multiple) {
                result = [];

                for (var k in value) {
                  var v = value[k];
                  result.push({id: v[0], text: v[1]});
                }

                callback(result);
              } else {
                result = {id: value[0], text: value[1]};
              }
            }

            callback(result);
          }
        };

        if ($el.attr('data-allow-blank'))
          opts['allowClear'] = true;

        opts['multiple'] = multiple;

        $el.select2(opts);
      }

      /**
      * Process data-role attribute for the given input element. Feel free to override
      *
      * @param {Selector} $el jQuery selector
      * @param {String} name data-role value
      */
      this.applyStyle = function($el, name) {
        // Process converters first
        for (var conv in fieldConverters) {
            var fieldConv = fieldConverters[conv];

            if (fieldConv($el, name))
                return true;
        }

        switch (name) {
            case 'popover-button':
                $el.popover({trigger: 'hover'});
                return true;
            case 'region-select2':
                $el.select2({
                    multiple: true,
                    width: "500px",
                    maximumSelectionSize:  parseInt($el.attr('single-value')),
                    createSearchChoice: function(term, data) {
                        yandex_lookup = ("Yandex".substr(0, term.length) == term ||
                                         "yandex".substr(0, term.length) == term ||
                                         "Яндекс".substr(0, term.length) == term ||
                                         "яндекс".substr(0, term.length) == term)
                        earth_lookup = ("Земля".substr(0, term.length) == term ||
                                        "земля".substr(0, term.length) == term ||
                                        "10000".substr(0, term.length) == term ||
                                        "Earth".substr(0, term.length) == term)
                        if (!yandex_lookup && !earth_lookup) {
                            return;
                        }
                        if (yandex_lookup) {
                            return {id: 9999, text: "Яндекс (Москва)"};
                        }
                        if (earth_lookup) {
                            return {id: 10000, text: "Земля"};
                        }
                    },
                    ajax: {
                        url: "/suggest-geo",
                        dataType: "json",
                        cache: true,
                        data: function(term, page) {
                            return {
                                part: term,
                                highlight: 0,
                                type: "addr",
                                callback: "",
                                v: 8,
                                bases: "district,locality,area,province,country"
                            };
                        },
                        results: function(data, page) {
                            var regions = new Array();
                            $.map(data[1], function(item) {
                                if (item.geoid)
                                    regions.push({
                                        id: item.geoid,
                                        text: "("+item.geoid+") "+item.name
                                    });
                            });
                            return {
                                results: regions,
                                more: false
                            }
                        }
                    },
                    initSelection: function(element, callback) {
                        var ids = [];
                        var data = [];
                        $(element.attr('Rvalue').split(";")).each(function() {
                            var params = this.split(',');
                            if (params.length == 2) {
                                data.push({id: params[0], text: params[1]});
                                ids.push(params[0]);
                            }
                        })
                        element.val(ids.join(","));
                        callback(data);
                    }
                }).select2('val', []);
                return true;
            case 'select2':
                var opts = {
                    width: 'resolve'
                };

                if ($el.attr('data-allow-blank'))
                    opts['allowClear'] = true;

                var tags = $el.attr('data-tags');
                if (tags) {
                    NOT_OP = '!'
                    $.extend(opts, {
                        tokenSeparators: [','],
                        tags: $.map($el.attr('data-tags').split(';'), function(item){
                            var params = item.split(',');
                            return {id: params[0], text: params[(params.length == 2)?1:0]};
                        }),
                        initSelection: function (element, callback) {
                            var data = [];
                            $(splitVal(element.val(), opts.separator)).each(function () {
                                var obj = { id: this, text: this },
                                    tags = opts.tags;
                                if ($.isFunction(tags)) tags=tags();
                                $(tags).each(function() {
                                    if (equal(this.id, obj.id)) {
                                        obj = this; return false;
                                    }
                                    if ((obj.id.length && obj.id[0] == NOT_OP) && equal(NOT_OP+this.id, obj.id)) {
                                        obj = {id: NOT_OP+this.id, text: NOT_OP+this.text}; return false;
                                    }
                                });
                                data.push(obj);
                            });

                            callback(data);
                        },
                        formatResult: function(result, container, query, escapeMarkup) {
                            var markup=[];
                            result.text = result.text.strip_condition()
                            result.id = result.id.strip_condition()
                            if (query.term.length && query.term[0] == NOT_OP && result.text != query.term) {
                                result.text = NOT_OP + result.text;
                                result.id = NOT_OP + result.id;
                            }

                            window.Select2.util.markMatch(result.text, query.term, markup, escapeMarkup);
                            return markup.join("");
                        },
                        matcher: function(term, text) {
                            if (term.length && NOT_OP == term[0])
                                term = term.slice(1);

                            strip = window.Select2.util.stripDiacritics
                            return strip(''+text).toUpperCase().indexOf(strip(''+term).toUpperCase()) >= 0;
                        },
                    });
                }

                if ($el.attr('data-placeholder')) {
                    opts['placeholder'] = $el.attr('data-placeholder');
                }

                if ($el.attr('single-value')) {
                    opts['maximumSelectionSize'] = 1;
                }

                $el.select2(opts);
                return true;
            case 'select2-ajax':
                processAjaxWidget($el, name);
                return true;
            case 'datepicker':
                $el.datetimepicker({
                  minView: 'month'
                });
                return true;
            case 'datetimepicker':
                $el.datetimepicker();
                return true;
            case 'timepicker':
                $el.datetimepicker({
                  startView: 'day',
                  maxView: 'day',
                  formatViewType: 'time'
                });
                return true;
        }
      };

      /**
      * Add inline form field
      *
      * @method addInlineField
      * @param {Node} el Button DOM node
      * @param {String} elID Form ID
      */
      this.addInlineField = function(el, elID) {
        // Get current inline field
        var $el = $(el).closest('.inline-field');
        // Figure out new field ID
        var id = elID;

        var $parentForm = $el.parent().closest('.inline-field');

        if ($parentForm.hasClass('fresh')) {
          id = $parentForm.attr('id');
          if (elID) {
            id += '-' + elID;
          }
        }

        var $fieldList = $el.find('> .inline-field-list');
        var maxId = 0;
        var partsId;

        $fieldList.children('.inline-field').each(function(idx, field) {
            var $field = $(field);

            var parts = $field.attr('id').split('-');
            idx = parseInt(parts[parts.length - 1], 10) + 1;

            if (idx > maxId) {
                maxId = idx;
                partsId = parts;
            }
        });

        var prefix;
        if (partsId) {
            partsId[partsId.length - 1] = maxId;
            prefix = partsId.join('-');
        } else {
            prefix = id + '-' + maxId;
        }

        // Get template
        var $template = $($el.find('> .inline-field-template').text());

        // Set form ID
        $template.attr('id', prefix);

        // Mark form that we just created
        $template.addClass('fresh');

        // Fix form IDs
        $('[name]', $template).each(function(e) {
            var me = $(this);

            var id = me.attr('id');
            var name = me.attr('name');

            id = prefix + (id !== '' ? '-' + id : '');
            name = prefix + (name !== '' ? '-' + name : '');

            me.attr('id', id);
            me.attr('name', name);
        });

        $template.appendTo($fieldList);

        // Select first field
        $('input:first', $template).focus();

        // Apply styles
        this.applyGlobalStyles($template);
      };

      /**
      * Apply global input styles.
      *
      * @method applyGlobalStyles
      * @param {Selector} jQuery element
      */
      this.applyGlobalStyles = function(parent) {
        var self = this;

        $('[data-role]', parent).each(function() {
            var $el = $(this);
            self.applyStyle($el, $el.attr('data-role'));
        });
      };

      /**
      * Add a field converter for customizing styles
      *
      * @method addFieldConverter
      * @param {converter} function($el, name)
      */
      this.addFieldConverter = function(converter) {
          fieldConverters.push(converter);
      };
    };

    // Add on event handler
    $('body').on('click', '.inline-remove-field' , function(e) {
        e.preventDefault();

        if (confirm('Delete subfield?')) {
            var form = $(this).closest('.inline-field');
            if (!$(form).next('.inline-field').length) {
                $(form).prev('.inline-field').children('.inline-field-control').find('i.icon-arrow-down').addClass("hide");
            }
            if (!$(form).prev('.inline-field').length) {
                $(form).next('.inline-field').children('.inline-field-control').find('i.icon-arrow-up').addClass("hide");
            }
            form.remove();
        }
    });

    // Expose faForm globally
    var faForm = window.faForm = new AdminForm();

    // Apply global styles for current page after page loaded
    $(function() {
        if (window.location.hash == '#btm') {
            $('.flashed_messages').hide();
            $('.flashed_messages_btm').show();
        }
        faForm.applyGlobalStyles(document);
    });
})();
