from localization_admin.views.base_model import BaseModelView
from flask.ext.admin.helpers import get_redirect_target
from flask.ext.admin.model.helpers import get_mdict_item_or_list
from flask.ext.admin.base import expose
from flask.ext.admin.form import FormOpts
import localization_admin.views.helpers as h2
from flask import request, redirect, url_for
from mongoengine.context_managers import switch_collection


def cross_collection(f):

    def wrapped(self, *args, **kwargs):
        collection_name = self.get_collection_name(request)
        if collection_name:
            with switch_collection(self.model, collection_name):
                return f(self, *args, **kwargs)
        else:
            return f(self, *args, **kwargs)

    return wrapped


class BaseCrossCollectionModelView(BaseModelView):

    def get_collection_name(self, request):
        raise NotImplementedError

    @expose('/')
    @cross_collection
    def index_view(self):
        return super(BaseCrossCollectionModelView, self).index_view()

    @expose('/edit/', methods=('GET', 'POST'))
    @cross_collection
    def edit_view(self):
        return super(BaseCrossCollectionModelView, self).edit_view()

    @expose('/new/', methods=('GET', 'POST'))
    @cross_collection
    def create_view(self):
        return super(BaseCrossCollectionModelView, self).create_view()

    @expose('/import/', methods=('GET', 'POST'))
    @cross_collection
    def import_view(self):
        return super(BaseCrossCollectionModelView, self).import_view()

    @expose('/export/', methods=('GET', 'POST'))
    @cross_collection
    def export_view(self):
        return super(BaseCrossCollectionModelView, self).export_view()

    @expose('/ticket/', methods=('GET',))
    @cross_collection
    def ticket(self):
        return super(BaseCrossCollectionModelView, self).ticket()

    @expose('/copy/', methods=('GET', 'POST'))
    @cross_collection
    def copy_view(self):
        return_url = get_redirect_target() or url_for('.index_view')
        request_id = get_mdict_item_or_list(request.args, 'id')
        if request_id is None:
            return redirect(return_url)
        if not self.can_create:
            return redirect(return_url)
        model = self.get_one(request_id)
        if model is None:
            return redirect(return_url)
        if request.method == 'GET':
            form = self.create_form(obj=model)
            form_opts = FormOpts(widget_args=self.form_widget_args,
                                 form_rules=self._form_create_rules)
            if h2.is_ObjectId(form.id.data):
                form.id.data = h2.generate_id(self.check_id)
            else:
                num = 1
                while not self.check_id("%s-copy%s" % (form.id.data, num)):
                    num += 1
                form.id.data = "%s-copy%s" % (form.id.data, num)

            return self.render(self.create_template, form=form, form_opts=form_opts, return_url=return_url)
        #  POST
        return super(BaseCrossCollectionModelView, self).create_view()  # dodjing second cross_collection decorator

    @expose('/delete/', methods=('POST',))
    @cross_collection
    def delete_view(self):
        return super(BaseCrossCollectionModelView, self).delete_view()
