#  encoding: utf-8
from flask import request
from flask.ext.admin.base import BaseView, expose
from werkzeug.exceptions import BadRequest


class ModeSelectView(BaseView):
    """
        Ajax setting/resetting admin_mode
    """
    @expose('/', methods=('POST',))
    def main(self):
        try:
            index = request.data.find('adminMode=')
            if index != -1:
                admin_mode = request.data[index + 10:][:1]
            request._cookies_to_set['admin_mode'] = admin_mode
        except:
            raise BadRequest(description="Mode specification not found")
        return 'OK', 200

    is_visible = lambda x: False


view = ModeSelectView('Test request', endpoint='settings/mode')
