# encoding: utf-8
from flask import request, url_for
from flask.ext.admin.helpers import get_form_data
from localization_admin.models.permissions import Permission
from localization_admin.views import access
from localization_admin.views.base_model import BaseCrossCollectionModelView


class PermissionsView(BaseCrossCollectionModelView):

    # View only for admins, people with universal access are unable to see it

    column_list = ['id', 'role']
    column_searchable_list = column_list

    list_template = 'permissions/list.html'

    can_edit = False

    @property
    def logging_prefix(self):
        resource_name = request and request.args.get('resource_name', 'universal') or 'universal'
        if resource_name != 'admins':
            return resource_name.capitalize() + ' Permissions'
        else:
            return "Admins"

    def get_collection_name(self, request):
        resource_name = request.args.get('resource_name', 'universal')
        if resource_name != 'universal':
            if resource_name != 'admins':
                collection_name = resource_name + '._permissions'
            else:
                collection_name = resource_name
        else:
            collection_name = None
        return collection_name

    def create_form(self, obj=None, **kwargs):
        return self._create_form_class(get_form_data(), obj=obj, **kwargs)

    def _handle_view(self, name, **kwargs):
        request.read_only = False
        resource_name = request.args.get('resource_name', 'universal')
        if access.can_edit_permissions(self, resource_name=resource_name):
            pass
        else:
            return self.render('permissions/info.html', admins=access.get_admins())

    action_disallowed_list = ['delete']

    @property
    def _template_args(self):
        args = super(PermissionsView, self)._template_args
        resource_name = request.args.get('resource_name', None)
        if not resource_name:
            resource_name = 'universal'

        args['resource_name'] = resource_name
        if resource_name != 'universal':
            if resource_name != 'admins':
                args['title'] = 'People with access to %s' % (resource_name,)
            else:
                args['title'] = 'Admins'
        else:
            args['title'] = 'People with universal access'
        return args

    def _get_url(self, view=None, page=None, sort=None, sort_desc=None,
                 search=None, filters=None, resource_name=None):
        """
            Generate page URL with current page, sort column and
            other parameters.

            :param view:
                View name
            :param page:
                Page number
            :param sort:
                Sort column index
            :param sort_desc:
                Use descending sorting order
            :param search:
                Search query
            :param filters:
                List of active filters
        """
        if not search:
            search = None

        if not page:
            page = None

        if not resource_name:
            resource_name = request.args.get('resource_name', 'universal')

        kwargs = dict(page=page, sort=sort, desc=sort_desc, search=search, resource_name=resource_name)

        if filters:
            for i, pair in enumerate(filters):
                idx, value = pair

                key = 'flt%d_%s' % (i, self.get_filter_arg(idx, self._filters[idx]))
                kwargs[key] = value

        return url_for(view, **kwargs)


view = PermissionsView(Permission, 'Administration', url='/permissions')
