# encoding: utf-8
from localization_admin.views.base_model import BaseModelView
from localization_admin.models.support_info import StartrekInteraction


class StartrekInteractionView(BaseModelView):
    column_list = ('project', 'enabled', 'excluded')
    column_exclude_list = ('id',)
    form_columns = ('id', 'project', 'enabled', 'excluded')

    column_searchable_list = ('project',)
    can_delete = True

    logging_prefix = "Startrek Interaction"

    security_level = 'protected'
    resource_name = 'startrek_interaction'

    form_widget_args = {
        'id': {'readonly': True},
    }


view = StartrekInteractionView(StartrekInteraction, 'Startrek Interaction', category='Information',
                               endpoint='info/st_interaction')
