import os

bind = '[::]:8080'
worker_class = 'sync'
workers = os.environ.get('GUNICORN_NUM_WORKERS', 1)
timeout = 10
graceful_timeout = 10

access_log_format = ('%(t)s %({Host}i)s %({x-forwarded-for-y}i)s '
                     '"%(r)s" %(s)s %(l)s "%(a)s" %(l)s %(L)s %(l)s %(b)s %(l)s '
                     '"X-Request-Id: %({x-request-id}i)s" ')

limit_request_line = 8190
