import os

bind = '[::]:80'
worker_class = 'sync'
workers = os.environ.get('GUNICORN_NUM_WORKERS', 1)
timeout = 60
graceful_timeout = 5

pidfile = '/var/run/gunicorn.pid'

access_log_format = ('%(t)s %({Host}i)s %({x-forwarded-for-y}i)s '
                     '"%(r)s" %(s)s %(l)s "%(a)s" %(l)s %(L)s %(l)s %(b)s %(l)s '
                     '"X-Request-Id: %({x-request-id}i)s" ')
logconfig = '/etc/gunicorn/logging.ini'

limit_request_line = 8190
