# coding: utf-8
from yaphone.localization_admin.src.db import db
from .version_range_application import VersionRangeAndroidApplication
from yaphone.localization_admin.src.models.support_info import YandexApp


class ApplicationConditions(db.EmbeddedDocument):
    Android = db.ListField(db.EmbeddedDocumentField(VersionRangeAndroidApplication),
                           default=None,
                           db_field='package_installed',
                           help_text='Condition for presense of Android applications on the device')
    iOS = db.ListField(db.PropertyReferenceField(YandexApp, 'ios_scheme'),
                       default=None,
                       db_field='schema_defined',
                       help_text='Condition for presense of iOS applications on the device')
