from yaphone.localization_admin.src.db import db

CLID_REGEX = "clid\d+"


class LocalizationClid(db.EmbeddedDocument):
    number = db.IntField(required=True, min_value=0)
    value = db.ListField(db.IntField(required=True, min_value=0, verbose_name='value'), verbose_name='values',
                         help_text="defined values will be compared using OR condition")


class Clid(db.EmbeddedDocument):
    name = db.StringField(required=True, regex=CLID_REGEX, help_text="Clid's ID")
    value = db.StringField(required=True, help_text="Clid's value")
