from yaphone.localization_admin.src.db import db
from yaphone.localization_admin.src.models.support_info import OperationSystem
from yaphone.localization_admin.src.models.details.version_range import VersionRange


family_choices = [('android', 'Android'), ('iphone', 'iOS'), ('wp', 'Windows Phone')]


class MobilePlatform(db.EmbeddedDocument):
    name = db.ReferenceField(OperationSystem, required=True)
    version = db.EmbeddedDocumentField(VersionRange)

    def __str__(self):
        return self.name


class MobilePlatformFamily(db.EmbeddedDocument):
    name = db.StringField(required=True, choices=family_choices)
    version = db.EmbeddedDocumentField(VersionRange)

    def __str__(self):
        return self.name
