import datetime
from yaphone.localization_admin.src.db import db

# datetime.strftime dislikes years before 1900
# https://bugs.python.org/issue1777412
MIN_SUPPORTED_DATETIME = datetime.datetime(1900, 1, 1)


class TimeRange(db.EmbeddedDocument):
    From = db.DateTimeField(db_field='from', help_text="time >= from")
    to = db.DateTimeField(help_text="time < to")

    def clean(self):
        if self.From and self.From < MIN_SUPPORTED_DATETIME:
            raise db.ValidationError("'From' year must be >= 1900 (by UTC)")
        if self.to and self.to < MIN_SUPPORTED_DATETIME:
            raise db.ValidationError("'to' year must be >= 1900 (by UTC)")
        if self.From and self.to and self.From > self.to:
            raise db.ValidationError("'From' datetime must be < than 'to' datetime")
