from yaphone.localization_admin.src.db import db
from yaphone.localization_admin.src.models.support_info import YandexApp
from .version_range import VersionRange


class VersionRangeApplication(db.EmbeddedDocument):
    name = db.ReferenceField(YandexApp, required=True)
    version = db.EmbeddedDocumentField(VersionRange)

    def __str__(self):
        return self.name


class VersionRangeAndroidApplication(db.EmbeddedDocument):
    name = db.PropertyReferenceField(YandexApp, 'android_package_name', required=True)
    version = db.EmbeddedDocumentField(VersionRange)

    def __str__(self):
        return self.name
