from yaphone.localization_admin.src.db import db


class Roles:
    Nobody, Viewer, Editor, Moderator = (None, 'viewer', 'editor', 'moderator')

    @staticmethod
    def most_privileged(roles_list):
        if Roles.Moderator in roles_list:
            return Roles.Moderator
        if Roles.Editor in roles_list:
            return Roles.Editor
        if Roles.Viewer in roles_list:
            return Roles.Viewer
        return Roles.Nobody


class Permission(db.Document):
    id = db.StringField(primary_key=True)
    role = db.StringField(required=True, choices=[(getattr(Roles, s), s)
                                                  for s in dir(Roles)
                                                  if '_' not in s and getattr(Roles, s)])

    # default collection is universal access collection
    meta = {'db_alias': 'permissions',
            'collection': 'mongo_admin_universal_access'}
