from yaphone.localization_admin.src.db import db


class YandexApp(db.Document):
    id = db.StringField(primary_key=True)
    title = db.StringField(required=True, unique=True)
    ios_bundle = db.StringField(regex='^(ru|com)(\.[a-z]+)+$', unique=True, sparse=True)
    ios_scheme = db.StringField(regex='^.+://$', unique=True, sparse=True)
    android_package_name = db.StringField(regex='^(ru|com)(\.[a-z]+)+$', unique=True, sparse=True)
    wp_app_id = db.StringField(regex='^[0-9a-f]{8}(-[0-9a-f]{4}){3}-[0-9a-f]{12}$', unique=True, sparse=True)

    meta = {'db_alias': 'localizations',
            'collection': 'localization._Yandex_apps'}

    def __str__(self):
        return self.title
