from collections import OrderedDict

import yenv
from yaphone.localization_admin.src import secrets
from yaphone.localization_admin.src.version import VERSION

#  Common
DEBUG = yenv.choose_key_by_type({
    'production': False,
    'development': True,
}, fallback=True)

BACKGROUND_COLOR = yenv.choose_key_by_type({
    'development': '#D0D0FF',  # blue
    'testing': '#D0FFD0',  # green
    'production': '#FFFFFF',  # white
}, fallback=True)

ADMIN_LOGO = 'Mongo databases editing interface (%s) v%s' % (yenv.type.capitalize(), VERSION)

DEFAULT_ENVIRONMENTS = OrderedDict([
    ('production', 'localization-admin.phone.yandex.net'),
    ('testing', 'localization-admin.tst.phone.yandex.net'),
])

ENVIRONMENTS = OrderedDict([(key, '') for key in DEFAULT_ENVIRONMENTS])


def get_host_from_qloud(yenv_type):
    return DEFAULT_ENVIRONMENTS.get(yenv_type, '')


def get_qloud_envs_urls():
    if not ENVIRONMENTS.get(yenv.type):
        ENVIRONMENTS[yenv.type] = ''

    for yenv_type, url in ENVIRONMENTS.items():
        if not url:
            try:
                host = get_host_from_qloud(yenv_type)
                if host:
                    ENVIRONMENTS[yenv_type] = host
            except:
                pass
    return ENVIRONMENTS


SECRET_KEY = secrets.SECRET_KEY

LOCALIZATIONS_DBNAME = 'localizations_db'
PERMISSIONS_DBNAME = 'permissions_db'

mongodb_uri_template = 'mongodb://{user}:{password}@{hosts}/{database}'

MONGO_HOSTS = yenv.choose_key_by_type({
    'production': [
        'vla-8h8moxom5mcqvhxq.db.yandex.net:27018',
        'sas-350atkewrtqdqznw.db.yandex.net:27018',
        'iva-g4rokm43mg6rjizc.db.yandex.net:27018',
    ],
    'testing': [
        'sas-m6ed1vwh01lxm0td.db.yandex.net:27018',
        'vla-5xqt1wmnesk3vqto.db.yandex.net:27018',
    ],
}, fallback=True)

MONGODB_SETTINGS = [
    {
        'db': LOCALIZATIONS_DBNAME,
        'host': mongodb_uri_template.format(
            user=secrets.MONGO_USER,
            password=secrets.MONGO_PASSWORD,
            hosts=','.join(MONGO_HOSTS),
            database=LOCALIZATIONS_DBNAME,
        ),
        'alias': 'localizations'
    },
    {
        'db': PERMISSIONS_DBNAME,
        'host': mongodb_uri_template.format(
            user=secrets.MONGO_USER,
            password=secrets.MONGO_PASSWORD,
            hosts=','.join(MONGO_HOSTS),
            database=PERMISSIONS_DBNAME,
        ),
        'alias': 'permissions'
    },
]

CONTACTS = ['smoroz', 'griganton', 'igoshkin']

DEFAULT_FOLLOWERS_LIST = []

STARTREK_QUEUE = 'PHONEXP'

STARTREK_ISSUE_TYPE = dict(key=u'experiment')

STARTREK_ENABLED = yenv.choose_key_by_type({
    'production': True,
    'stress': False
}, fallback=True)


# Oauth
YANDEX_CLIENT_ID = secrets.OAUTH_KEY
YANDEX_CLIENT_SECRET = secrets.OAUTH_SECRET
YANDEX_ACCESS_TOKEN_URL = 'https://oauth.yandex-team.ru/token'
YANDEX_AUTHORIZE_URL = 'https://oauth.yandex-team.ru/authorize'
OAUTH_INFO_URL = 'https://login.yandex-team.ru/info'


#  Localizations
EXCLUDED_LOCALIZATION_PROJECTS = {
    'ads', 'ads_v3', 'ads_actions_v3',
    'distribution_customization',
    'staging_distribution_customization',
    'other_apps',
    'other_apps.apps.deep_link',
    'other_apps.apps.features',
    'other_apps.ordering',
    'other_apps.targeting'
}

COMMON_LOCALIZATION_PREFIX = 'localization.'

HTTP_GEOBASE_URL = yenv.choose_key_by_type({
    'production': 'http://geobase.qloud.yandex.ru',
    'testing': 'http://geobase-test.qloud.yandex.ru',
}, fallback=True)
