import flask_admin.helpers as h
from bson.objectid import ObjectId
from flask import request
from mongoengine.connection import get_connection
from pymongo import errors as py_errors
from wtforms.fields import BooleanField, FormField

import yaphone.localization_admin.src.settings as settings
# noinspection PyUnresolvedReferences
from yaphone.localization_admin.src.views.fields import GeoCodesField  # noqa
# noinspection PyUnresolvedReferences
from yaphone.localization_admin.src.helpers import generate_id  # noqa
from yaphone.localization_admin.src.geobase import geobase_lookuper


db_errors = (
    py_errors.ConnectionFailure,
    py_errors.CursorNotFound,
    py_errors.ExecutionTimeout,
    py_errors.ExceededMaxWaiters
)


def is_ObjectId(_id):
    try:
        ObjectId(_id)
        return True
    except:
        return False


def get_localization_ordered_fields(resource_name=None):
    if not resource_name:
        return None
    if request.admin_mode:
        return None
    connection = get_connection(alias='localizations')[settings.LOCALIZATIONS_DBNAME]
    ordered_fields = connection.localization_models.find_one({'_id': resource_name})
    if ordered_fields:
        return ordered_fields['fields']
    else:
        default_ordered_fields = connection.localization_models.find_one({'_id': '__default'})
        if default_ordered_fields:
            return default_ordered_fields['fields']
        else:
            return None


def get_distribution_ordered_fields():
    if request.admin_mode:
        return None
    return {'id': True,
            'title': True,
            'clids': True,
            'switch_search': True}


def coerce_if_not_none(coerce):
    def new_coerce(value):
        if value is None:
            return None
        else:
            return coerce(value)

    return new_coerce


def show_field_controls(field):
    if isinstance(field, (FormField, BooleanField,)):
        return False
    if 'disabled' in getattr(field.widget, 'kwargs_override', dict()):
        return False
    if h.is_required_form_field(field):
        return False
    return True


def show_field_on_load(field):
    if not show_field_controls(field):
        return True
    if field.data is not None:
        return True
    if field.errors:
        return True
    return False


def show_description(field):
    return bool(getattr(field, 'description', False))


def region_by_id(region_id):
    region = geobase_lookuper.region_by_id(int(region_id))
    return u'(%s) %s' % (region_id, region.name)


def set_error(model, form, error):
    try:
        error_field_name = str(error).split(u'$')[1].split()[0]
        candidates = list()
        for field_name, field in model._fields.items():
            if error_field_name.startswith(field.db_field):
                candidates.append(field_name)
        if len(candidates) == 1:
            duplicate_value = u'{' + str(error).split(u'{')[-1]
            field_to_set_error = getattr(form, candidates[0], None)
            if field_to_set_error:
                field_to_set_error.errors.append(u'Duplicate value: {value}'.format(value=duplicate_value))
                return True
    except:
        pass
    return False
