from flask_admin.base import AdminIndexView

from yaphone.localization_admin.src.settings import CONTACTS, BACKGROUND_COLOR


class CustomIndexView(AdminIndexView):
    """
        Custom index view with developers contacts
    """

    @property
    def _template_args(self):
        args = super(CustomIndexView, self)._template_args
        args['contacts'] = CONTACTS
        args['body_background_color'] = BACKGROUND_COLOR
        return args

index_view = CustomIndexView(template='index.html', url='/', name='About')
