from yaphone.localization_admin.src.views.base_model import BaseModelView
from yaphone.localization_admin.src.models.support_info.locale import LocaleModel


class LocaleView(BaseModelView):
    column_list = ['language', 'language_title', 'country', 'country_title']
    column_searchable_list = column_list
    show_id_on_edit = False
    can_delete = True

    logging_prefix = "Locales"

    security_level = 'protected'
    resource_name = 'locales'


view = LocaleView(LocaleModel, 'Locales', category='Information', endpoint='info/locales')
