import re

from bson.objectid import ObjectId
from wtforms.validators import DataRequired, ValidationError, Regexp, StopValidation, Optional


class StrictOptional(Optional):

    def __call__(self, form, field):
        if not field.raw_data and field.data is None:
            field.errors[:] = []
            raise StopValidation()


class Required(DataRequired):
    """ My version of wtforms Required. Difference is that my version doesn't think 0 or False is no data"""

    def __call__(self, form, field):
        if field.data is None or (isinstance(field.data, str) and not field.data.strip()):
            raise StopValidation('This field is required')


class PrimaryKey(object):
    """
        Does not allow to save two documents with same id.
        Use only on create!
    """
    def __init__(self, model, message='Object with this ID already exists'):
        self.model = model
        self.message = message

    def __call__(self, form, field):
        if field.data in [getattr(obj, field.short_name) for obj in self.model.objects]:
            raise ValidationError(self.message)
        try:
            str(field.data)
        except:
            raise ValidationError("Forbidden symbols in primary key! Stick to ascii.")


class URL(Regexp):

    def __init__(self, message=None):
        if message is None:
            message = "Invalid URL!"
        regex = r'^[0-9_a-z-]+://(.+)?$'
        super(URL, self).__init__(regex, re.IGNORECASE, message)

    def __call__(self, form, field):
        super(URL, self).__call__(form, field, self.message)


class HttpsURL(Regexp):

    def __init__(self, message=None):
        if message is None:
            message = "Expected https url!"
        regex = r'^https://(.+)?$'
        super(HttpsURL, self).__init__(regex, re.IGNORECASE, message)

    def __call__(self, form, field):
        super(HttpsURL, self).__call__(form, field, self.message)


class ValidObjectId(object):

    def __call__(self, form, field):
        try:
            ObjectId(field.data)
        except:
            raise ValidationError("Not a valid ObjectId")
