from flask_admin.form import RenderTemplateWidget
from wtforms.fields import SelectFieldBase
from wtforms.widgets import HTMLString, html_params


class CustomMongoFileInput(object):
    """
        Renders a file input field.
    """
    def __call__(self, field, **kwargs):

        kwargs.setdefault('id', field.id)
        kwargs['name'] = field.name
        first_kwargs = kwargs.copy()
        second_kwargs = kwargs.copy()
        first_kwargs.update(second_kwargs.pop('first_only', dict()))
        second_kwargs.update(first_kwargs.pop('second_only', dict()))
        first_kwargs.pop('first_only', None)
        first_kwargs.update({'urlinput': 1})
        second_kwargs.pop('second_only', None)
        return HTMLString(
            ('<input %s>' % html_params(value=field.data or '', type='text', **first_kwargs)) +
            ('<input %s>' % html_params(type='file', **second_kwargs))
        )


class WidgetConverter(object):
    def __init__(self, embedded_widget, field, kwargs=None):
        self.embedded_widget = embedded_widget
        self.kwargs_override = kwargs or dict()

    def __call__(self, field, **kwargs):
        kwargs.update(self.kwargs_override)
        if 'h2' in kwargs:
            if not hasattr(field, '__iter__') or isinstance(field, (SelectFieldBase,)):
                if not isinstance(self.embedded_widget, (RenderTemplateWidget,)):
                    del kwargs['h2']
        if getattr(field, 'description', False) and not hasattr(field, '__iter__'):
            kwargs['placeholder'] = field.description
        return self.embedded_widget(field, **kwargs)


class WidgetDisabler(object):
    """
        Wrap for widget
        Can disable widget subclassed from :
        disableable_base_classes = [Input, Select, TextArea, FileInput, AjaxSelect2Widget]
    """
    def __init__(self, widget):
        self.widget = widget

    def __call__(self, *args, **kwargs):
        kwargs.update({'disabled': 'disabled'})
        return self.widget.__call__(*args, **kwargs)


class CustomInlineFormWidget(RenderTemplateWidget):
    def __init__(self):
        super(CustomInlineFormWidget, self).__init__('inline_form.html')

    def __call__(self, field, **kwargs):
        kwargs.setdefault('form_opts', getattr(field, 'form_opts', None))
        return super(CustomInlineFormWidget, self).__call__(field, **kwargs)


class CustomInlineFieldListWidget(RenderTemplateWidget):
    def __init__(self):
        super(CustomInlineFieldListWidget, self).__init__('widgets/inline_field_list.html')

    def __call__(self, field, **kwargs):
        return super(CustomInlineFieldListWidget, self).__call__(field, **kwargs)


class GeoCodesSelectWidget(RenderTemplateWidget):
    def __init__(self):
        super(GeoCodesSelectWidget, self).__init__('widgets/geocodes_select.html')


class TaggedStringWidget(RenderTemplateWidget):
    def __init__(self, tags):
        self.tags = tags
        super(TaggedStringWidget, self).__init__('widgets/tagged_string.html')

    def __call__(self, field, **kwargs):
        tags = self.tags() if callable(self.tags) else self.tags
        kwargs.setdefault('tags', u';'.join(tags))
        return super(TaggedStringWidget, self).__call__(field, **kwargs)


class CustomCheckboxInput(RenderTemplateWidget):
    """
        Sends '' if field is unchecked
    """
    def __init__(self):
        super(CustomCheckboxInput, self).__init__('widgets/custom_checkbox.html')
