#!/usr/bin/env python

import argparse
import json
from urllib import urlencode
from urllib2 import Request, urlopen, HTTPError
from urlparse import urljoin


default_settings = {
    'http_headers': {
        'User-Agent': 'monrun.checker/1.0 (fake fake; linux 0.0)'
    },
    'nginx_url': 'http://127.0.0.1'
}

def check_not_empty(response):
    try:
        json_document = json.loads(response.read())
    except ValueError:
        return failed()

    if len(json_document) > 0:
        return ok()
    else:
        return failed()

client_settings = {
    "checks": {
        "/api/v1/weather_forecast": {
            "params": {
                "locale": "ru_RU",
                "lat": "55.35",
                "lon": "35.55",
                "timezone": "Europe/Moscow"
            },
            "execution_interval": "60"
        },
        "/api/v1/grouped_apps": {
            "params": {
                "type": "Multiapps_card",
                "place": "allapps/all"
            },
            "execution_interval": "60"
        },
        "/api/v1/recommend": {
            "params": {
                "block": "format:Single_app;place:tab1",
                "reserve": "3"
            },
            "http_headers": {
                "Host": "advisor-widget.mobile.yandex.net"
            },
            "execution_interval": "60"
        },
        "/api/v1/categories_for_apps": {
            "params": {
                "package_names": "ru.yandex.disk,ru.yandex.mail"
            }
        },
        "/api/v1/search_apps": {
            "params": {
                "query": "yandex"
            }
        },
        "/api/v1/icons_for_apps": {
            "params": {
                "package_names": "ru.yandex.disk,com.ubercab",
                "size": "mdpi"
            }
        },
        "/api/v1/icons_for_urls": {
            "params": {
                "url": "http://linkedin.com"
            }
        },
        "/api/v1/config": {},
        "/api/v1/experiments": {},
        "/api/v1/wallpapers": {},
        "/api/v1/themes": {},
        "/api/v1/bugreport": {},
        "/api/v2/all_experiments/launcher": {
            "extra_check": check_not_empty
        }
    },
    "http_headers": {
        "Host": "launcher.mobile.yandex.net",
        "X-YaUuid": "94270b66-0a1c-4aaf-bce9-5f0e2782a3ea"
    }
}

def ok():
    return '0;Ok'

def warning(msg=None):
    return '1;%s' % (msg or 'Warning')

def failed(msg=None):
    return '2;%s' % (msg or 'Failed')


def perform_check(path, params, headers, extra_check):
    if not path.endswith('/'):
        path += '/'

    url = '%s?%s' % (
        urljoin(default_settings['nginx_url'], path), urlencode(params))

    request = Request(url, headers=headers)
    try:
        response = urlopen(request)
        if not response.getcode() == 200:
            return failed()
        if extra_check:
            return extra_check(response)
        else:
            return ok()
    except HTTPError as ex:
        if ex.code == 400:
            return warning(str(ex))

        return failed(str(ex))

parser = argparse.ArgumentParser()

parser.add_argument('--check', type=str, dest='check')

def main():
    args = parser.parse_args()
    try:
        check = client_settings['checks'][args.check]

        headers = default_settings['http_headers']
        headers.update(client_settings.get('http_headers', {}))
        headers.update(check.get('http_headers', {}))

        return perform_check(args.check, check.get('params', {}), headers, check.get('extra_check'))
    except KeyError:
        return warning('Improperly configured, nothing to do')
    except Exception as e:
        return warning('Something wrong: {}'.format(e))


if __name__ == '__main__':
    print main()
