import os

bind = '[::]:8001'
worker_class = 'gthread'
threads = os.getenv('GUNICORN_THREADS', 1)
timeout = 600
graceful_timeout = 5

logconfig = 'logging.dev.ini'

access_log_format = ('%(t)s %({Host}i)s %({x-forwarded-for-y}i)s '
                     '"%(r)s" %(s)s %(l)s "%(a)s" %(l)s %(L)s %(l)s %(b)s %(l)s '
                     '"X-Request-Id: %({x-request-id}i)s" '
                     '"X-YaUUID: %({x-yauuid}i)s" '
                     '"X-Wifi-Mac: %({x-wifi-mac}i)s" '
                     '"X-Ethernet-Mac: %({x-ethernet-mac}i)s" '
                     '"Build-Fingerprint: %({build-fingerprint}i)s"')
