import os

bind = '[::]:80'
worker_class = 'gthread'
threads = os.getenv('GUNICORN_THREADS', 4)
timeout = 10
graceful_timeout = 5

pidfile = '/var/run/gunicorn.pid'

access_log_format = ('%(t)s %({Host}i)s %({x-forwarded-for-y}i)s '
                     '"%(r)s" %(s)s %(l)s "%(a)s" %(l)s %(L)s %(l)s %(b)s %(l)s '
                     '"X-Request-Id: %({x-request-id}i)s" '
                     '"X-YaUUID: %({x-yauuid}i)s" '
                     '"X-Wifi-Mac: %({x-wifi-mac}i)s" '
                     '"X-Ethernet-Mac: %({x-ethernet-mac}i)s" '
                     '"Build-Fingerprint: %({build-fingerprint}i)s"')

logconfig = '/etc/gunicorn/logging.ini'

limit_request_line = 8190
