"""Initial

Revision ID: 0000
Revises: 
Create Date: 2020-01-28 18:11:28.621528

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = '0000'
down_revision = None
branch_labels = None
depends_on = None


def upgrade():
    op.create_table('category',
    sa.Column('id', sa.String(), nullable=False),
    sa.Column('name', sa.String(), nullable=False),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('local_update',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('download_url', sa.String(), nullable=True),
    sa.Column('package_name', sa.String(260), nullable=False),
    sa.Column('version_code', sa.Integer(), nullable=True),
    sa.Column('version_name', sa.String(), nullable=True),
    sa.Column('size', sa.Integer(), nullable=True),
    sa.Column('app_name', sa.String(), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('market_update',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('package_name', sa.String(260), nullable=False),
    sa.Column('version_code', sa.Integer(), nullable=True),
    sa.Column('version_name', sa.String(), nullable=True),
    sa.Column('title', sa.String(), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('store_app',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('size', sa.Integer(), nullable=False),
    sa.Column('app_name', sa.String(), nullable=False),
    sa.Column('updated_at', sa.Integer(), nullable=True),
    sa.Column('banner_url', sa.String(), nullable=False),
    sa.Column('description', sa.String(), nullable=False),
    sa.Column('package_name', sa.String(260), nullable=False),
    sa.Column('version_name', sa.String(), nullable=False),
    sa.Column('version_code', sa.Integer(), nullable=False),
    sa.Column('download_url', sa.String(), nullable=False),
    sa.Column('installs_num', sa.Integer(), nullable=False),
    sa.Column('company_name', sa.String(), nullable=False),
    sa.Column('restriction_age', sa.Integer(), nullable=False),
    sa.Column('category_id', sa.String(), nullable=False),
    sa.Column('app_rating', postgresql.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=False, server_default='4.3'),
    sa.PrimaryKeyConstraint('id'),
    sa.ForeignKeyConstraint(['category_id'], ['category.id'], )
    )
    op.create_table('screenshot',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('url', sa.String(), nullable=False),
    sa.Column('preview_url', sa.String(), nullable=False),
    sa.Column('app_id', sa.Integer(), nullable=False),
    sa.PrimaryKeyConstraint('id'),
    sa.ForeignKeyConstraint(['app_id'], ['store_app.id'], )
    )
    op.create_table('subscription',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('device_id', sa.String(32), nullable=False),
    sa.Column('package_name', sa.String(260), nullable=False),
    sa.PrimaryKeyConstraint('id'),
    )


def downgrade():
    op.drop_table('local_update')
    op.drop_table('market_update')
    op.drop_table('screenshot')
    op.drop_table('store_app')
    op.drop_table('category')
    op.drop_table('subscription')
