"""Remove download_url

Revision ID: 0004
Revises: 0003
Create Date: 2019-12-17 13:07:38.205422

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = '0004'
down_revision = '0003'
branch_labels = None
depends_on = None


DELETE_NULL_BRANCHES_COMMAND = '''
DELETE FROM {tablename} WHERE branch IS NULL;
'''


EXTRACT_FILENAME_COMMAND = '''
UPDATE {tablename} as target SET filename = (
    SELECT SUBSTRING(download_url FROM '/([^/]+)$')
    FROM {tablename} as source
    WHERE target.id = source.id
);
'''


RESTORE_URL_COMMAND = '''
UPDATE {tablename} as target SET download_url = (
    SELECT CONCAT_WS('/', 'https://ecosystemstorage.s3.mdst.yandex.net', '{s3_directory}', branch, filename)
    FROM {tablename} as source
    WHERE target.id = source.id
);
'''


def extract_filenames(tablename, delete_empty_branches=False):
    if delete_empty_branches:
        op.execute(DELETE_NULL_BRANCHES_COMMAND.format(tablename=tablename))
    op.add_column(tablename, sa.Column('filename', sa.String(), nullable=True))
    op.execute(EXTRACT_FILENAME_COMMAND.format(tablename=tablename))
    op.alter_column(tablename, 'filename', nullable=False)


def restore_url(tablename, s3_directory, nullable=False):
    op.add_column(tablename, sa.Column('download_url', sa.VARCHAR(), nullable=True, autoincrement=False))
    op.execute(RESTORE_URL_COMMAND.format(tablename=tablename, s3_directory=s3_directory))
    if not nullable:
        op.alter_column(tablename, 'download_url', nullable=False)


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    extract_filenames('local_update', delete_empty_branches=True)
    op.alter_column('local_update', 'branch',
               existing_type=sa.VARCHAR(),
               nullable=False)
    op.drop_column('local_update', 'download_url')
    extract_filenames('ota_update')
    op.drop_column('ota_update', 'download_url')
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    restore_url('ota_update', 'firmware')
    op.drop_column('ota_update', 'filename')
    restore_url('local_update', 'updates', nullable=True)
    op.alter_column('local_update', 'branch',
               existing_type=sa.VARCHAR(),
               nullable=True)
    op.drop_column('local_update', 'filename')
    # ### end Alembic commands ###
