"""Add changelog to ota update

Revision ID: 0007
Revises: 0006
Create Date: 2020-01-28 15:48:24.321142

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = '0007'
down_revision = '0006'
branch_labels = None
depends_on = None


def upgrade():
    op.create_table('changelog',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('title', sa.String(), nullable=True),
    sa.Column('description', sa.String(), nullable=False),
    sa.PrimaryKeyConstraint('id')
    )
    op.add_column('ota_update', sa.Column('changelog_id', sa.Integer(), nullable=True))
    op.create_foreign_key('ota_update_changelog_id_fkey', 'ota_update', 'changelog', ['changelog_id'], ['id'])


def downgrade():
    op.drop_constraint('ota_update_changelog_id_fkey', 'ota_update', type_='foreignkey')
    op.drop_column('ota_update', 'changelog_id')
    op.drop_table('changelog')
