"""Make updated_at be datetime

Revision ID: 0008
Revises: 0007
Create Date: 2019-12-30 17:56:42.316631

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = '0008'
down_revision = '0007'
branch_labels = None
depends_on = None


def upgrade():
    op.drop_column('store_app', 'updated_at')
    op.add_column('store_app',
    sa.Column('updated_at', sa.DateTime(timezone=True), server_default=sa.func.now(), nullable=False)
    )


def downgrade():
    op.drop_column('store_app', 'updated_at')
    op.add_column('store_app',
    sa.Column('updated_at', sa.Integer, nullable=True)
    )
