"""Add prebuilt apps

Revision ID: 0010
Revises: 0009
Create Date: 2020-01-31 11:33:55.731119

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = '0010'
down_revision = '0009'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('device_firmware',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('device', sa.String(), nullable=False),
    sa.Column('target', sa.String(), nullable=False),
    sa.Column('os_version', sa.String(), nullable=False),
    sa.Column('build_version', sa.String(), nullable=False),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('prebuilt_app',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('filename', sa.String(), nullable=False),
    sa.Column('local_name', sa.String(), nullable=False),
    sa.Column('privileged', sa.Boolean(), nullable=True),
    sa.Column('platform_apis', sa.Boolean(), nullable=True),
    sa.Column('module_name', sa.String(), nullable=True),
    sa.Column('module_class', sa.String(), nullable=True),
    sa.Column('certificate', sa.String(), nullable=True),
    sa.Column('owner', sa.String(), nullable=True),
    sa.Column('overrides_packages', sa.String(), nullable=True),
    sa.Column('module_tags', sa.String(), nullable=True),
    sa.Column('updated_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('device_firmware_id', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['device_firmware_id'], ['device_firmware.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('prebuilt_app')
    op.drop_table('device_firmware')
    # ### end Alembic commands ###
