"""add uploaded_at to store

Revision ID: 0012
Revises: 0011
Create Date: 2020-03-24 12:11:33.045445

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = '0012'
down_revision = '0011'
branch_labels = None
depends_on = None


COPY_COLUMN = '''
UPDATE {table_name} SET {column_to} = {column_from};
'''


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('store_app', sa.Column('uploaded_at', sa.DateTime(timezone=True), nullable=True))
    op.execute(
        COPY_COLUMN.format(
            table_name='store_app',
            column_from='updated_at',
            column_to='uploaded_at',
        )
    )
    op.alter_column('store_app', 'uploaded_at', nullable=False)
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column('store_app', 'uploaded_at')
    # ### end Alembic commands ###
