"""add notes

Revision ID: 0018
Revises: 0017
Create Date: 2020-06-19 10:00:52.471532

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = '0018'
down_revision = '0017'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('update_note',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('note', sa.String(), nullable=False),
    sa.PrimaryKeyConstraint('id')
    )
    op.add_column('local_update', sa.Column('note_id', sa.Integer(), nullable=True))
    op.create_foreign_key('local_update_note_fkey', 'local_update', 'update_note', ['note_id'], ['id'])
    op.add_column('ota_update', sa.Column('note_id', sa.Integer(), nullable=True))
    op.create_foreign_key('ota_update_note_fkey', 'ota_update', 'update_note', ['note_id'], ['id'])
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint('ota_update_note_fkey', 'ota_update', type_='foreignkey')
    op.drop_column('ota_update', 'note_id')
    op.drop_constraint('local_update_note_fkey', 'local_update', type_='foreignkey')
    op.drop_column('local_update', 'note_id')
    op.drop_table('update_note')
    # ### end Alembic commands ###
