"""add s3key field

Revision ID: 0020
Revises: 0019_add_md5_hash_to_ota_update
Create Date: 2020-09-01 16:29:06.739766

"""
from alembic import op
from sqlalchemy import orm
import sqlalchemy as sa

from yaphone.newpdater.src.updates.models import OtaUpdate, LocalUpdate


# revision identifiers, used by Alembic.
revision = '0020'
down_revision = '0019_add_md5_hash_to_ota_update'
branch_labels = None
depends_on = None


def fill_s3key_data(session):
    for ota in session.query(OtaUpdate).all():
        if ota.s3key is None:
            ota.s3key = f'firmware/{ota.branch}/{ota.filename}'
    for update in session.query(LocalUpdate).all():
        if update.s3key is None:
            update.s3key = f'updates/{update.branch}/{update.filename}'


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('local_update', sa.Column('s3key', sa.String(), nullable=True))
    op.add_column('ota_update', sa.Column('s3key', sa.String(), nullable=True))
    bind = op.get_bind()
    session = orm.Session(bind=bind)
    fill_s3key_data(session)
    session.commit()
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column('ota_update', 's3key')
    op.drop_column('local_update', 's3key')
    # ### end Alembic commands ###
