"""add s3key fields to store

Revision ID: 0021
Revises: 0020
Create Date: 2020-09-07 16:05:44.226272

"""
from alembic import op
from sqlalchemy import orm
from urllib.parse import urlparse
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = '0021'
down_revision = '0020'
branch_labels = None
depends_on = None


def key_from_url(url):
    if not url:
        return None
    return urlparse(url).path[1:]

def fill_screenshot_s3key_data(session):
    images = session.execute("SELECT id, url FROM screenshot")
    for (image_id, image_url) in images:
        session.execute(
            "UPDATE screenshot SET s3key = :s3key WHERE id = :id",
            {'id': image_id, 's3key': key_from_url(image_url)})


def fill_storeapp_s3key_data(session):
    apps = session.execute("SELECT id, download_url, banner_url, eula_url, privacy_url FROM store_app")
    for (app_id, download_url, banner_url, eula_url, privacy_url) in apps:
        session.execute(
            "UPDATE store_app SET "
            "s3key = :s3key, "
            "banner_s3key = :banner_s3key, "
            "eula_s3key = :eula_s3key, "
            "privacy_s3key = :privacy_s3key "
            "WHERE id = :id",
            {
                'id': app_id,
                's3key': key_from_url(download_url),
                'banner_s3key': key_from_url(banner_url),
                'eula_s3key': key_from_url(eula_url),
                'privacy_s3key': key_from_url(privacy_url),
            })


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('agreement')
    op.add_column('screenshot', sa.Column('s3key', sa.String(), nullable=True))
    op.add_column('store_app', sa.Column('banner_s3key', sa.String(), nullable=True))
    op.add_column('store_app', sa.Column('eula_s3key', sa.String(), nullable=True))
    op.add_column('store_app', sa.Column('privacy_s3key', sa.String(), nullable=True))
    op.add_column('store_app', sa.Column('s3key', sa.String(), nullable=True))
    bind = op.get_bind()
    session = orm.Session(bind=bind)
    fill_screenshot_s3key_data(session)
    fill_storeapp_s3key_data(session)
    session.commit()
    op.drop_column('screenshot', 'url')
    op.drop_column('screenshot', 'preview_url')
    op.drop_column('store_app', 'banner_url')
    op.drop_column('store_app', 'eula_url')
    op.drop_column('store_app', 'privacy_url')
    op.drop_column('store_app', 'download_url')
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('screenshot', sa.Column('preview_url', sa.VARCHAR(), autoincrement=False, nullable=True))
    op.add_column('screenshot', sa.Column('url', sa.VARCHAR(), autoincrement=False, nullable=True))
    op.add_column('store_app', sa.Column('download_url', sa.VARCHAR(), autoincrement=False, nullable=True))
    op.add_column('store_app', sa.Column('privacy_url', sa.VARCHAR(), autoincrement=False, nullable=True))
    op.add_column('store_app', sa.Column('eula_url', sa.VARCHAR(), autoincrement=False, nullable=True))
    op.add_column('store_app', sa.Column('banner_url', sa.VARCHAR(), autoincrement=False, nullable=True))
    op.drop_column('screenshot', 's3key')
    op.drop_column('store_app', 's3key')
    op.drop_column('store_app', 'privacy_s3key')
    op.drop_column('store_app', 'eula_s3key')
    op.drop_column('store_app', 'banner_s3key')
    op.create_table('agreement',
                    sa.Column('id', sa.INTEGER(), autoincrement=True, nullable=False),
                    sa.Column('name', sa.VARCHAR(), autoincrement=False, nullable=True),
                    sa.Column('eula', sa.VARCHAR(), autoincrement=False, nullable=True),
                    sa.Column('privacy', sa.VARCHAR(), autoincrement=False, nullable=True),
                    sa.PrimaryKeyConstraint('id', name='agreement_pkey')
                    )
    # ### end Alembic commands ###
