"""Move note field to updates model

Revision ID: 0024
Revises: 0023
Create Date: 2021-01-15 11:03:42.186771

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy import orm

# revision identifiers, used by Alembic.
revision = '0024'
down_revision = '0023'
branch_labels = None
depends_on = None


def fill_note_field(session):
    notes = {id_: note for (id_, note) in session.execute("SELECT id, note FROM update_note")}
    updates = session.execute("SELECT id, note_id FROM local_update WHERE note_id IS NOT NULL")
    for update_id, note_id in updates:
        session.execute(
            "UPDATE local_update SET "
            "note = :note "
            "WHERE id = :update_id",
            {
                'update_id': update_id,
                'note': notes[note_id],
            })
    otas = session.execute("SELECT id, note_id FROM ota_update WHERE note_id IS NOT NULL")
    for update_id, note_id in otas:
        session.execute(
            "UPDATE ota_update SET "
            "note = :note "
            "WHERE id = :update_id",
            {
                'update_id': update_id,
                'note': notes[note_id],
            })


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('local_update', sa.Column('note', sa.String(), nullable=True))
    op.add_column('ota_update', sa.Column('note', sa.String(), nullable=True))
    bind = op.get_bind()
    session = orm.Session(bind=bind)
    fill_note_field(session)
    session.commit()
    op.drop_constraint('ota_update_note_fkey', 'ota_update', type_='foreignkey')
    op.drop_column('ota_update', 'note_id')
    op.drop_constraint('local_update_note_fkey', 'local_update', type_='foreignkey')
    op.drop_column('local_update', 'note_id')
    op.drop_table('update_note')
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column('local_update', 'note')
    op.drop_column('ota_update', 'note')
    op.create_table('update_note',
                    sa.Column('id', sa.Integer(), nullable=False),
                    sa.Column('note', sa.String(), nullable=False),
                    sa.PrimaryKeyConstraint('id')
                    )
    op.add_column('local_update', sa.Column('note_id', sa.Integer(), nullable=True))
    op.create_foreign_key('local_update_note_fkey', 'local_update', 'update_note', ['note_id'], ['id'])
    op.add_column('ota_update', sa.Column('note_id', sa.Integer(), nullable=True))
    op.create_foreign_key('ota_update_note_fkey', 'ota_update', 'update_note', ['note_id'], ['id'])
    # ### end Alembic commands ###
