import logging
import requests
import requests.exceptions
import yenv

from flask import current_app, request

from yaphone.newpdater.src.admin import service, tvm

logger = logging.getLogger(__name__)


def get_user_ip():
    return request.headers.get('X-Forwarded-For-Y') or request.headers.get('X-Real-IP') or request.remote_addr


class AuthError(Exception):
    pass


def get_yateam_user():
    if yenv.type == 'development':
        return service.get_user('admin')

    session_id = request.cookies.get('Session_id')
    if not session_id:
        logger.debug('Missing Session_id in cookies, returning anonymous')
        return service.get_anonymous()

    params = dict(
        format='json',
        userip=get_user_ip(),
        method='sessionid',
        sessionid=session_id,
        host='yandex-team.ru',
    )
    try:
        headers = tvm.client.add_service_ticket_header(current_app.config['BLACKBOX_CLIENT'].value)
    except tvm.TVMServiceTicketError:
        logger.exception('Error obtaining service ticket')
        raise AuthError
    url = current_app.config['BLACKBOX_URL']
    try:
        response = requests.get(url=url, params=params, headers=headers)
        response.raise_for_status()
    except requests.exceptions.HTTPError:
        logger.exception('HTTP error accessing blackbox')
        raise AuthError
    try:
        result = response.json()
        username = result['login']
    except(KeyError, ValueError, TypeError):
        logger.exception('Blackbox response parsing error')
        raise AuthError
    return service.get_user(username)
