from flask_admin.form import FileUploadField
from wtforms import fields


class UpdateFileField(FileUploadField):
    ALLOWED_EXTENSIONS = []
    LABEL = ''

    def __init__(self, **kwargs):
        super().__init__(label=kwargs.pop('label', self.LABEL), allowed_extensions=self.ALLOWED_EXTENSIONS, **kwargs)

    def _save_file(self, data, filename):
        return filename

    def _get_path(self, filename):
        return filename


class ApkFileField(UpdateFileField):
    ALLOWED_EXTENSIONS = ['APK']
    LABEL = 'APK file'


class FirmwareFileField(UpdateFileField):
    ALLOWED_EXTENSIONS = ['ZIP', 'IMG']
    LABEL = 'FOTA file'


class PictureField(UpdateFileField):
    ALLOWED_EXTENSIONS = ['JPG', 'PNG', 'JPEG']
    LABEL = 'Picture'


class DocumentField(UpdateFileField):
    ALLOWED_EXTENSIONS = ['HTML', 'PDF']
    LABEL = 'Document'


class ReadOnlyStringField(fields.StringField):
    def populate_obj(self, obj, name):
        pass
