from datetime import datetime

from yaphone.newpdater.src.common.databases import updater_db as db

ROLE_ADMIN = 'admin'
ROLE_DEVELOPER = 'developer'
ROLE_SUPPORT = 'support'
ROLES = (ROLE_ADMIN, ROLE_DEVELOPER, ROLE_SUPPORT)
ROLES_DESCRIPTION = {
    ROLE_ADMIN: 'Администратор',
    ROLE_DEVELOPER: 'Разработчик',
    ROLE_SUPPORT: 'Поддержка'
}
DEFAULT_ROLES = tuple()


class UserMixin:
    @property
    def is_authenticated(self):
        return True


class Anonymous(UserMixin):
    @property
    def is_authenticated(self):
        return False


class AdminRoles(db.Model):
    __tablename__ = 'admin_roles'
    id = db.Column(db.Integer(), primary_key=True, autoincrement=True)
    user_id = db.Column(db.Integer, db.ForeignKey('admin_users.id'), nullable=False)
    user = db.relationship('AdminUser', uselist=False, lazy=True)
    type = db.Column(db.String(100), nullable=False)

    def __repr__(self):
        return '{}:{}'.format(self.user.username, self.type)


class AdminUser(UserMixin, db.Model):
    __tablename__ = 'admin_users'
    id = db.Column(db.Integer(), primary_key=True)
    username = db.Column(db.String(50), nullable=False, unique=True)
    email = db.Column(db.String(100), nullable=False, unique=True)
    created_on = db.Column(db.DateTime(), default=datetime.utcnow)
    updated_on = db.Column(db.DateTime(), default=datetime.utcnow, onupdate=datetime.utcnow)
    roles = db.relationship('AdminRoles', uselist=True, lazy=False, cascade='delete')

    def has_role(self, role_name):
        return role_name in self.get_roles()

    def get_roles(self):
        return [role.type for role in self.roles]

    def get_id(self):
        return self.email

    def __repr__(self):
        return f'{self.id}:{self.username}'
