from yaphone.newpdater.src.common.databases import updater_db as db, on_error_retry
from yaphone.newpdater.src.admin import models


@on_error_retry
def find_user(username):
    return db.session.query(models.AdminUser).filter_by(username=username).first()


@on_error_retry
def add_user(email, username):
    user = models.AdminUser(email=email, username=username)
    roles = [models.AdminRoles(user=user, type=role) for role in models.DEFAULT_ROLES]
    user.roles = roles
    db.session.add(user)
    for role in roles:
        db.session.add(role)
    db.session.commit()
    return user


@on_error_retry
def get_anonymous():
    return models.Anonymous()


@on_error_retry
def find_all_users():
    return db.session.query(models.AdminUser).all()


@on_error_retry
def find_roles_description():
    return models.ROLES_DESCRIPTION


@on_error_retry
def add_role(user, role):
    db.session.add(models.AdminRoles(user=user, type=role))
    db.session.commit()


@on_error_retry
def delete_role(user, role):
    db.session.query(models.AdminRoles).filter_by(user=user, type=role).delete()
    db.session.commit()
